	function [Ratio, Remaind] = LONG_DIV(Pnum, Qden)
 
	%	Divides the polynomial Pnum with Qden and returns the polynomial, Ratio,
	%	and the numerator of the remainder, Remaind.
	% 	The polynomials have the highest power first.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-07-22
	%	Modified by: 	LW 2016-04-22	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	NP = length(Pnum);
	NQ = length(Qden);
	k = NP-NQ+1;
	Ratio = zeros(1, k);
	R = Pnum;
	for j = 1:k
		Ratio(j) = Pnum(j)/Qden(1);
		y = zeros(1,k+1-j); y(1) = 1;
		R = POLYSUB(R, Ratio(j)*POLYMULT(Qden, y));
	end
	Remaind(1) = 1;
	for j = 1:NP-k
		Remaind(j) = R(j+k);
	end
